<?php 
   /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../template/stile.php";
    include "../classi/DocumentoContabile.php";
    include "../gUtil/GestoreTabella.php";
    include "../classi/Tabella.php";
    
    include "include/controlloLogin.php";
    
    if(isset($_GET["id"])) {
        $documento = new DocumentoContabile($geecomDb,filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $documento->caricaDatiDalDatabase();
        $tipoDocumento = $documento->getTipo();
        
        if($tipoDocumento=="prima nota") {
            $fraseModifcaDocumento = "Modifica la voce prima nota n. {$documento->getNumeroDocumento()}";
            $tipoDocumentoPlurale = "Prime note";
        }
        else if($tipoDocumento=="ricevuta"){
            $fraseModifcaDocumento = "Modifica la ricevuta n. {$documento->getNumeroDocumento()} del ".date("d/m/Y",strtotime($documento->getDataEmissione()));
            $tipoDocumentoPlurale  = "Ricevute";
        }
        else if($tipoDocumento=="fattura"){
            $fraseModifcaDocumento = "Modifica la fattura n. {$documento->getNumeroDocumento()} del ".date("d/m/Y",strtotime($documento->getDataEmissione()));
            $tipoDocumentoPlurale  = "Fatture";
        }
        else {
            $fraseModifcaDocumento = "Modifica preventivo n. {$documento->getNumeroDocumento()}";
            $tipoDocumentoPlurale = "Preventivi";
        }
    }
    else {
        $tipoDocumento = filter_input(INPUT_GET, "tipo",FILTER_SANITIZE_STRING);
        $documento     = new DocumentoContabile($geecomDb,0);
        $documento->setTipo($tipoDocumento);
        
        if($tipoDocumento=="prima nota") {
            $fraseCreaDocumento   = "Crea una voce prima nota";
            $tipoDocumentoPlurale = "Prime note";
        }
        else if($tipoDocumento=="ricevuta"){
            $fraseCreaDocumento    = "Crea una ricevuta";
            $tipoDocumentoPlurale  = "Ricevute";
        }
        else if($tipoDocumento=="fattura"){
            $fraseCreaDocumento    = "Crea una fattura";
            $tipoDocumentoPlurale  = "Fatture";
        }
        else {
            $fraseCreaDocumento    = "Crea un preventivo";
            $tipoDocumentoPlurale = "Preventivi";
        }
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
    $likElencoDocumenti    = "documentiContabili.php?tipo=$tipoDocumento";
?>
<!doctype html>
<html lang="it">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
        <title>Geecom Admin - Creazione documento contabile</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "include/barraSuperiore.php";

                include "include/header.php";

                include "include/barraMenu.php";
            ?>
        </header>
	

    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div class="row pt-4">
                <div class="col-12">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                    Creazione $tipoDocumento riuscita
                                    <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                          <span aria-hidden=\"true\">&times;</span>
                                    </button>
                                </div>";
                        }
                        else if($status==250) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                    Modifica $tipoDocumento riuscita
                                    <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                          <span aria-hidden=\"true\">&times;</span>
                                    </button>
                                </div>";
                        }
                        else if($status==260) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                    Duplicazione $tipoDocumento riuscita
                                    <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                          <span aria-hidden=\"true\">&times;</span>
                                    </button>
                                </div>";
                        }
                        else if($status==270) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                    Voce documento inserita
                                    <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                          <span aria-hidden=\"true\">&times;</span>
                                    </button>
                                </div>";
                        }
                    ?>
                </div>
            </div>
            
            <form action="../controller/controllerDocumentiContabili.php" method="post">

                <div class="form-row justify-content-between mb-3">
                    <div class="col-auto d-flex">
                        <nav aria-label="breadcrumb" class="align-self-center">
                            <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                <li class="breadcrumb-item"><a href="home.php">Home</a></li>
                                <li class="breadcrumb-item"><a href="<?php echo $likElencoDocumenti ?>"><?php echo $tipoDocumentoPlurale ?></a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?= ($documento->getId()>0) ? $fraseModifcaDocumento : $fraseCreaDocumento ?></li>
                            </ol>
                        </nav>
                    </div>
                    <div class="col-auto text-right">
                        <a class="btn btn-primary mr-1" href="creaDocumentoContabile.php?tipo=<?php echo $tipoDocumento ?>">Crea <?php echo(($tipoDocumento=="preventivo") ? "nuovo" : "nuova") ?><i class="fas fa-plus ml-2"></i></a>
                        <a class="btn btn-outline-primary mr-1" href="<?php echo $likElencoDocumenti ?>"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                        <button type="submit" class="btn btn-primary mr-1"><i class="fas fa-check mr-2"></i>Salva</button>
                        <button type="button" class="btn btn-warning" onclick="location.href='../controller/controllerDocumentiContabili.php?operazione=duplica&id=<?= $documento->getId() ?>';"><i class="far fa-clone mr-2"></i>Duplica</button>
                    </div>
                </div>
                
                <div class="form-row">
                    <input type="text" class="d-none" name="operazione" value="<?= ($documento->getId()>0) ? "modifica" : "crea" ?>">
                    <input type="text" class="d-none" name="tipo" value="<?= $documento->getTipo() ?>">
                    <input type="text" class="d-none" name="id" value="<?= $documento->getId() ?>">
                    
                    <div class="col-lg-5">
                        <div class="card mb-4 box-shadow-lite">
                            <div class="card-body wrapper-sezioni-pagina">
                                
                                <div class="<?= ($documento->getTipo() != "ricevuta" && $documento->getTipo() != "fattura") ? "row" : "d-none" ?>">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label for="titolo-articolo">Oggetto</label>
                                            <input  type="text" class="form-control" id="titolo-articolo" name="oggetto" value="<?= $documento->getOggetto() ?>" placeholder="Oggetto">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-row">
                                    <div class="<?php echo(($tipoDocumento=="preventivo") ? "d-none" : "col-lg-4") ?>" id="divEntrataUscita">
                                        <div class="form-group">
                                            <label for="titolo-articolo">Tipo</label>
                                            <select name="entrataUscita" class="form-control">
                                                <option value="Entrata" <?= ($documento->getEntrataUscita()=="Entrata") ? "selected" : "" ?>>Entrata</option>
                                                <option value="Uscita" <?= ($documento->getEntrataUscita()=="Uscita") ? "selected" : "" ?>>Uscita</option>
                                            </select>
                                            <small class="form-text text-muted">Contrassegna come entrata i documenti emessi da te, come uscita quelli emessi a te da altri fornitori.</small>
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label for="titolo-articolo">Utente</label>
                                            <select name="idUtente" class="form-control">
                                                <?php 
                                                    $query = "SELECT * FROM geec_utenti WHERE ruolo LIKE 'utente'";
                                                    $risEtichette = $geecomDb->eseguiQueryLettura($query);
                                                    echo"<option value=\"0\">Seleziona</option>";
                                                    while($utente = $risEtichette->fetch_assoc()) {
                                                        $stringaSelezionata = ($utente["id"]==$documento->getIdUtente()) ? "selected" : "";
                                                        echo"<option value=\"{$utente["id"]}\" $stringaSelezionata>{$utente["nome"]} {$utente["cognome"]} - {$utente["organizzazione"]}</option>";
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">Il destinatario del tuo documento</small>
                                        </div>
                                    </div>

                                    <div class="col-lg-4">
		                            <label for="titolo-articolo">Etichetta documento</label>
		                            <select name="etichetta" class="form-control">
		                                <?php 
		                                    $query = "SELECT * FROM geecAd_etichette WHERE tipo LIKE 'contabilita'";
		                                    $risEtichette = $geecomDb->eseguiQueryLettura($query);
		                                    echo"<option value=\"\">Nessuna</option>";
		                                    while($etichetta = $risEtichette->fetch_assoc()) {
		                                        $stringaSelezionata = ($documento->getEtichetta()==$etichetta["nome"]) ? "selected" : "";
		                                        echo"<option value=\"{$etichetta["nome"]}\" $stringaSelezionata>{$etichetta["nome"]}</option>";
		                                    }
		                                ?>
		                            </select>
                                    </div>
                                </div>
                               
                                <div class="form-row" id="divDatiFattura">
                                    <div class="<?php echo(($tipoDocumento=="fattura" && $documento->getEntrataUscita()=="Uscita") ? "col-lg-4" : "d-none") ?>">
                                        <div class="form-group">
                                            <label for="titolo-articolo">Imponibile</label>
                                            <input  type="number" class="form-control" id="titolo-articolo" name="imponibile" value="<?= $documento->getImponibile() ?>" placeholder="Imponibile">
                                        </div>
                                    </div>
                                    
                                    <div class="<?php echo(($tipoDocumento=="fattura" && $documento->getEntrataUscita()=="Uscita") ? "col-lg-4" : "d-none") ?>">
                                        <div class="form-group">
                                            <label for="titolo-articolo">IVA</label>
                                            <input  type="number" class="form-control" id="titolo-articolo" name="iva" value="<?= $documento->getIva() ?>" placeholder="IVA">
                                        </div>
                                    </div>
                                    
                                    <div class="<?= ($documento->getEntrataUscita()=="Uscita") ? "col-lg-4" : "d-none" ?>">
                                        <div class="form-group">
                                            <label for="titolo-articolo">Totale €</label>
                                            <input  type="number" step="0.01" class="form-control" id="totale" name="totale" value="<?= $documento->getTotale() ?>" placeholder="Totale">
                                        </div>
                                    </div>
                                                          
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label for="titolo-articolo">Metodo pagamento</label>
                                            <select name="metodoPagamento" class="form-control">
                                                <?php
                                                    $query = "SELECT * FROM geecAd_etichette WHERE tipo LIKE 'metodoPagamento'";
                                                    $risEtichette = $geecomDb->eseguiQueryLettura($query);
                                                    while($metodoPagamento = $risEtichette->fetch_assoc()) {
                                                        $stringaSelezionata = ($metodoPagamento["nome"]==$documento->getMetodoPagamento()) ? "selected" : "";
                                                        echo"<option value=\"{$metodoPagamento["nome"]}\" $stringaSelezionata>{$metodoPagamento["nome"]}</option>";
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label for="titolo-articolo">Data pagamento</label>
                                            <input  type="date" class="form-control" id="dataPagamento" name="dataPagamento" value="<?= $documento->getDataPagamento() ?>">
                                        </div>
                                    </div>
                                    
                                    <div class="<?php echo(($tipoDocumento=="preventivo") ? "col-md-8" : "d-none") ?>" id="divAggiuntiviPreventivo">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="titolo-articolo">Giorni necessari</label>
                                                    <input  type="number" class="form-control" id="titolo-articolo" name="giorniNecessari" value="<?= $documento->getGiorniNecessari() ?>" placeholder="Giorni necessari a svolgere il lavoro">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="titolo-articolo">Validità preventivo</label>
                                                    <input  type="number" class="form-control" id="titolo-articolo" name="giorniValidita" value="<?= $documento->getGiorniValidita() ?>" placeholder="Validità del preventivo in giorni">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <a data-toggle="collapse" href="#descrizione">
	                            <?= ($documento->getTipo()=="fattura" || $documento->getTipo()=="ricevuta") ? "Note" : "Descrizione" ?>
	                        </a>
		 
		                    <div id="descrizione" class="collapse mt-2">
                            		<textarea class="form-control tiny" id="descrizione" name="testo"><?= $documento->getTesto() ?></textarea>
		                    </div>
                                
                                <button type="submit" class="btn btn-primary float-right mt-3"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                    </div><!--/Colonna principale -->
                    <!-- Colonna principale -->
            </form>
                    <!--Colonna secondaria -->
                    <div class="col-lg-7 align-self-start sticky-top">
                        <?php
                            if($documento->getEntrataUscita()!="Uscita") {
                        ?>
                            <div class="card">
                                <div class="card-body">
                                    <?php
                                        if(isset($_GET["id"])) {
                                            $parametri = array("tabella"=>"geecAd_vociDocumentiContabili", "elementiPerPagina"=>25,"parametriRicerca"=>array("idDocumento"=>$documento->getId()),"ajax"=>false);
                                            $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"creaDocumentoContabile.php");

                                            if(isset($_GET["pag"])) {
                                                $ris = $ricerca->eseguiRicerca($_GET["pag"]);
                                            }
                                            else {
                                                $ris = $ricerca->eseguiRicerca(1);
                                            }

                                            $colonne = array("Descrizione","Quantità","Costo unitario","IVA %","");
                                            $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                            $tabella->setTipo("normale");
                                            while($voceDocumento = $ris->fetch_assoc()) {
                                                $tabella->aggiungiNuovaRiga(array("<b>{$voceDocumento["descrizione"]}</b>",$voceDocumento["quantita"],$voceDocumento["prezzo"],$voceDocumento["iva"]),[]);
                                            }
                                            $tabella->stampa();
                                            $ricerca->stampaPaginazione(true,"creaDocumentoContabile.php?id={$documento->getId()}");
                                            
	                                    ?>

						<form name="formAggiungiVoce" action="../controller/controllerDocumentiContabili.php" method="post">
						    <input type="text" class="d-none" name="operazione" value="creaVoceDocumento">
						    <input type="text" class="d-none" name="id" value="<?= $documento->getId() ?>">

						    <div class="form-row mt-5">
							<div class="form-group col-lg-4">
							    <label>Descrizione</label>
							    <input type="text" class="form-control" id="descrizioneVoce" name="descrizione" required>
							</div>

							<div class="form-group col-lg-8">
						    		<div class="form-row row-cols-lg-5">
									<div class="form-group col">
									    <label>Quantità</label>
									    <input type="number" class="form-control" id="quantita" name="quantita" required>
									</div>

									<div class="form-group col">
									    <label>Prezzo</label>
									    <input type="number" class="form-control" id="prezzo" name="prezzo" required>
									</div>

									<?php
										if($documento->getTipo()!="ricevuta") {
									?>
										<div class="form-group col">
										    <label>IVA %</label>
										    <input type="number" class="form-control" id="iva" name="iva" required>
										</div>
									<?php
										}
										else {
									?>
										<input type="number" class="d-none" id="iva" name="iva" value="0" >
									<?php
										}
									?>
									
									<div class="form-group col">
									    <label for="descrizione" class="d-block">Salva</label>
									    <input type="checkbox" name="salvaVoce" class="js-switch" value="si" />
									</div>

									<div class="form-group col d-flex align-items-end">
						                		<button type="submit" class="btn btn-primary btn-block"><i class="fas fa-plus mr-2"></i>Aggiungi</button>
									</div>
						    		</div>
							</div>
						    </div>
						</form>
	                                    <?php 
                                        }
                                        else {
                                            ?>
                                            <div class="card bg-light text-center mb-3">
                                                <div class="card-body">
                                                    Salva il documento per aggiungere voci
                                                </div>
                                            </div>
                                            <?php
                                        }
                                    ?>
                                </div>
                            <?php
                            	if(($tipoDocumento=="fattura" || $tipoDocumento=="preventivo") && $documento->getEntrataUscita()=="Entrata") {
                                    ?>
                                    <div class="card-footer bg-white text-right">
                                    	<p class="mb-1">Imponibile: <?= $documento->getImponibile() ?> €</p>
                                    	<p class="mb-1">IVA: <?= $documento->getIva() ?> €</p>
                                    	<h5>Totale: <?= $documento->getTotale() ?> €</h5>
                                    </div>
                                    <?php
                            	}
                            	else if($tipoDocumento=="ricevuta" && $documento->getEntrataUscita()=="Entrata") {
                                    ?>
                                    <div class="card-footer bg-white text-right">
                                    	<h5>Totale: <?= $documento->getTotale() ?> €</h5>
                                    </div>
                                    <?php
                            	}
                            }
                        ?>
                            </div>
                    </div><!--/Colonna secondaria -->
                </div>
        </div>
    </main>

    <?php 
        include "include/footer.php";
        
        include "include/modal/cambiaPassword.php";
        
        include "include/modal/modalMenuComponenti.php";
                
        include "include/modal/operazioneCompletata.php";
    ?>
	  
	<!-- MODALS  -->
	<div class="modal fade" id="modalEliminaComponente" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare il documento?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                            <div class="align-self-center">
                                <span class="mr-3 align-self-center text-primary"><em id="nomeComponenteDaEliminare"></em></span>
                                <div id="nomeElementoDaEliminare"></div>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="componenteDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneComponentePagina()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
	
        <?php
            include "include/jsBaseAreaAmministrativa.php";
        ?>
        <script>
        	function caricaVocePredefinita(tipo) {
        		if(tipo=="vocePredefinita") {
        			var voceDocumentoPredefinita = document.getElementById("voceDocumentoPredefinita").value;
        			
        			if(voceDocumentoPredefinita>0) {
					$.ajax({
					    type:"POST",
					    url:"../controller/controllerDocumentiContabili.php",
					    data:{
						operazione:"stampaDatiVocePredefinita",
						id:<?= $documento->getId() ?>,
						idVoce:voceDocumentoPredefinita
					    },
					    success:function(esito) {
						var arrayEsito = esito.split("::");
						document.getElementById("prezzo").value          = arrayEsito[0];
						document.getElementById("iva").value             = arrayEsito[1];
						document.getElementById("descrizioneVoce").value = arrayEsito[2];
						document.getElementById("quantita").value        = 1;
					    },
					    error: function(xhr,status,error) {
						alert(status+" "+error);
					    }
					});        			
        			}
        		}
        	}
        </script>
    </body>
</html>
